(function(storyContent) {

    // Create ink story from the content using inkjs
    var story = new inkjs.Story(storyContent);

    var savePoint = "";
	var saveAudio = "";
	
	var fadeAudio;

    let savedTheme;
    let globalTagTheme;

    // Global tags - those at the top of the ink file
    // We support:
    //  # theme: dark
    //  # author: Your Name
    var globalTags = story.globalTags;
    if( globalTags ) {
        for(var i=0; i<story.globalTags.length; i++) {
            var globalTag = story.globalTags[i];
            var splitTag = splitPropertyTag(globalTag);

            // THEME: dark
            if( splitTag && splitTag.property == "theme" ) {
                globalTagTheme = splitTag.val;
            }

            // author: Your Name
            else if( splitTag && splitTag.property == "author" ) {
                var byline = document.querySelector('.byline');
                byline.innerHTML = "by "+splitTag.val;
            }
        }
    }

    var storyContainer = document.querySelector('.textContainer');
    var outerScrollContainer = document.querySelector('.outerContainer');

    // page features setup
    setupTheme(globalTagTheme);
    var hasSave = loadSavePoint();
    setupButtons(hasSave);

    // Set initial save point
    savePoint = story.state.toJson();
	
	// Initiate a variable to see if we're at the credits
	var reachedCredits = false;
	
	// If there's a save file, start the story. If not, listen for a click to start
	hasSave != false ? startStory() : document.addEventListener("click", startStory);
		
	// Function for the listener
	function startStory() {
		removeAll("p");
		continueStory(true);
		document.removeEventListener("click", startStory);
	};
		

    // Kick off the start of the story!
    //continueStory(true);

    // Main story processing function. Each time this is called it generates
    // all the next content up as far as the next set of choices.
    function continueStory(firstTime) {
		
	// Initialise or reset the animation timeline
	var animation = anime.timeline({loop: false, autoplay: true});
	
	// Listen for clicks to skip the text animation
	document.addEventListener("click", function(event){
		// Get all the choices for this section
		var revealChoices = document.querySelectorAll('.choice');
		
		// Prevent accidentally clicking on hidden elements such as unrevealed choices
		if (event.target.closest('.hide')) {
			event.stopPropagation();			
		};
		
		// Stop the animation
		animation.pause();
		// Jump to the end of the animation
		animation.seek(animation.duration);
		// Reveal all the unrevealed choices, suppressing the reveal animations for consistency
		for (i=0;i<revealChoices.length;i++){
			revealChoices[i].style.transition="all 0s";
			revealChoices[i].classList.remove('hide');
		};
	}, true);

        var paragraphIndex = 0;
        var delay = 0.0;

        // Don't over-scroll past new content
        var previousBottomEdge = firstTime ? 0 : contentBottomEdgeY();

        // Generate story text - loop through available content
        while(story.canContinue) {

            // Get ink to generate the next paragraph
            var paragraphText = story.Continue();
            var tags = story.currentTags;

            // Any special tags included with this line
            var customClasses = [];
            for(var i=0; i<tags.length; i++) {
                var tag = tags[i];

                // Detect tags of the form "X: Y". Currently used for IMAGE and CLASS but could be
                // customised to be used for other things too.
                var splitTag = splitPropertyTag(tag);

                // AUDIO: src
                if( splitTag && splitTag.property == "AUDIO" ) {
                  if('audio' in this) {
                    this.audio.pause();
                    this.audio.removeAttribute('src');
                    this.audio.load();
                  }
                  this.audio = new Audio(splitTag.val);
                  this.audio.play();
                }

                // AUDIOLOOP: src
                else if( splitTag && splitTag.property == "AUDIOLOOP" ) {
					
				// Save the audio for the save function
				saveAudio = splitTag.val;
				
				if ( this.audioLoop.src == 'file:///F:/Fork/The-Golden-Heist/Game%20Build/null' ) {
									
					this.audioLoop = new Audio(splitTag.val);
					this.audioLoop.play();
					this.audioLoop.loop = true;
				
				}
				
				else {
					
					fadeAudioLoop(splitTag.val);
					
				}
				
				}
				
								
                // IMAGE: src
                if( splitTag && splitTag.property == "IMAGE" ) {
                    var imageElement = document.createElement('img');
                    imageElement.src = splitTag.val;
                    storyContainer.appendChild(imageElement);

                    showAfter(delay, imageElement);
                    delay += 200.0;
                }

                // LINK: url
                else if( splitTag && splitTag.property == "LINK" ) {
                    window.location.href = splitTag.val;
                }

                // LINKOPEN: url
                else if( splitTag && splitTag.property == "LINKOPEN" ) {
                    window.open(splitTag.val);
                }

                // BACKGROUND: src
                else if( splitTag && splitTag.property == "BACKGROUND" ) {
                    outerScrollContainer.style.backgroundImage = 'url('+splitTag.val+')';
                }

                // CLASS: className
                else if( splitTag && splitTag.property == "CLASS" ) {
                    customClasses.push(splitTag.val);
                }
				
				// REACHEDCREDITS
				else if( splitTag && splitTag.property == "REACHEDCREDITS" ){
					reachedCredits = true;	
				}

                // CLEAR - removes all existing content.
                // RESTART - clears everything and restarts the story from the beginning
                else if( tag == "CLEAR" || tag == "RESTART" ) {
                    removeAll("p");
                    removeAll("img");

                    // Comment out this line if you want to leave the header visible when clearing
                    setVisible(".header", false);

                    if( tag == "RESTART" ) {
                        restart();
                        return;
                    }
                }
            }

            // Create paragraph element (initially hidden)
            var paragraphElement = document.createElement('p');
			
			// Add any custom classes derived from ink tags
			for(var i=0; i<customClasses.length; i++)
				paragraphElement.classList.add(customClasses[i]);
			
			// Wrap each sentence in its own span
			paragraphText = paragraphText.replace(/\.{3}"/g, "\u2026\"</span><span class='animateSentence contentText'>").replace(/[\.?!]\s/g, "$&</span><span class='animateSentence contentText'>").replace(/[\.?!]"\s(?![a-z]|Vira|Fabricius|Felix|Amaranthus)/g, "$&</span><span class='animateSentence contentText'>");
			
			// Add the spanned text to the HTML and finish the start and end tags
			paragraphElement.innerHTML = "<span class='animateSentence contentText'>" + paragraphText + "</span>";
			
			// If there's an span at the end of a paragraph which only contains a new line character (which will happen if terminal punctuation is correct), get rid of it
			paragraphElement.lastElementChild.textContent == "\n" ? paragraphElement.lastElementChild.remove() : null; 
			
			paragraphElement.classList.add('storytext');
			
            storyContainer.appendChild(paragraphElement);
          
        }

		  // Cross-Fade Animation for each sentence
		
		// Get all the sentences from this paragraph that have been wrapped in spans
		var animateTheseSentences = []
		
		reachedCredits ? null : animateTheseSentences = document.querySelectorAll('.animateSentence');
		
		// Loop through each sentence in turn
		for ( i = 0; i < animateTheseSentences.length; i++ ) {
			
			var textAnimateSpeed = 35; // Set the base animation speed (it's a multiplier of duration, so higher number means slower pace
		
			// Cache the current, previous, and next sentences in line
			var lastSentence = animateTheseSentences[i-1];
			var nextSentence = animateTheseSentences[i+1];
			var thisSentence = animateTheseSentences[i];
			
			// Then cache the lengths of their text content (with error handling for the first and last in the list)
			var lastSentenceLength = i == 0 ? 1 : lastSentence.textContent.length;
			var nextSentenceLength = i == animateTheseSentences.length-1 ? 0 : nextSentence.textContent.length;
			var thisSentenceLength = thisSentence.textContent.length;
			
			// Set a minimum and a maximum value for all of these
			var lastSentenceDuration = smoothSentenceAnimationLengths(lastSentenceLength, textAnimateSpeed);
			var nextSentenceDuration = smoothSentenceAnimationLengths(nextSentenceLength, textAnimateSpeed);
			var thisSentenceDuration = smoothSentenceAnimationLengths(thisSentenceLength, textAnimateSpeed);
			
			
			// Add the current sentence to the animation queue
			animation.add({
				targets: thisSentence,
				keyframes: [
				{style: 'color:white;', opacity:0,duration:0},
				{style: 'color:white;', opacity:1,duration: thisSentenceDuration},
				{style: 'color:#c7c7c7;', opacity: 1, duration: thisSentenceDuration}
					],
				easing: 'easeOutQuad',
			}, ('-='+lastSentenceDuration));
			
	
	}	
						
		// Remove the animation class from each added span so it doesn't re-animate. This is important when doing this once for each paragraph, rather than the whole current screen at once. 
			var finishedSentences = document.querySelectorAll('.animateSentence');
			for(i=0;i<finishedSentences.length;i++){
				finishedSentences[i].classList.remove('animateSentence');
				};

	
		// Create HTML choices from ink choices
        story.currentChoices.forEach(function(choice) {

            // Create paragraph with anchor element
            var choiceParagraphElement = document.createElement('p');
            choiceParagraphElement.classList.add("choice");
			
			// Is this choice tagged to flow back into previous paragraph? More at 11.
			var backflowThisChoice = false;
			var revealHiddenText = false;
			
			// Split off any choice tags for this choice
			var choiceOptions = splitChoiceTags(choice);
			
			// Go through each tag on this choice and check if it matches any of the following
			for ( i = 0; i<choiceOptions.tags.length; i++ ) {
				
				if ( choiceOptions.tags[i].includes("B") ) {
					backflowThisChoice = true
					var backflowTerminalPunct = choiceOptions.tags[i].charAt(1)
				}
				
				if ( choiceOptions.tags[i].includes("R") ) {
					revealHiddenText = true; 
				}
				
			};
			
			
			
            choiceParagraphElement.innerHTML = `<a href='#'>${choice.text}</a>`
            storyContainer.appendChild(choiceParagraphElement);

            // Fade choice in after a short delay -- currently calculated based on the total length of the animation timeline, plus the time taken by the previous sentence to cross-fade, with an additional .5s
            showAfter(animation.duration-smoothSentenceAnimationLengths(thisSentenceDuration, textAnimateSpeed)+500, choiceParagraphElement);
			
			// This currently doesn't account for very short or very long sentences!

            // Click on choice
            var choiceAnchorEl = choiceParagraphElement.querySelectorAll("a")[0];
            choiceAnchorEl.addEventListener("click", function(event) {

                // Don't follow <a> link
                event.preventDefault();
				
				if ( backflowThisChoice == true ) {
					var storyParagraphs = document.querySelectorAll('.storytext');
					
					var lastParagraph = storyParagraphs[storyParagraphs.length-1];
					
					if ( lastParagraph.textContent.lastIndexOf('...') == lastParagraph.textContent.length-4 ) {
						
						var ellipsisPosition = lastParagraph.innerHTML.lastIndexOf('...');
						
						lastParagraph.innerHTML = lastParagraph.innerHTML.substr(0, ellipsisPosition)+" "+lastParagraph.innerHTML.substr(ellipsisPosition+4)
					}
					
					lastParagraph.innerText += (" " + choice.text + backflowTerminalPunct);
				}
				
				if ( revealHiddenText == true ) {
					var revealThis = storyContainer.querySelector('.hide');
					revealThis.style.display = "inline";
					revealThis.classList.remove('hide');
				}


                // Remove all existing choices
                removeAll(".choice");

                // Tell the story where to go next
                story.ChooseChoiceIndex(choice.index);

                // This is where the save button will save from
                savePoint = story.state.toJson();

                // Aaand loop
                continueStory();
            });
        });

       // Extend height to fit
        // We do this manually so that removing elements and creating new ones doesn't
        // cause the height (and therefore scroll) to jump backwards temporarily.
        storyContainer.style.height = contentBottomEdgeY()+"px"; 

        if( !firstTime )
            scrollDown(previousBottomEdge);

    }

    function restart() {
        story.ResetState();

        setVisible(".header", true);

        // set save point to here
        savePoint = story.state.toJson();

        continueStory(true);

        outerScrollContainer.scrollTo(0, 0);
    }

    // -----------------------------------
    // Various Helper functions
    // -----------------------------------

    // Fades in an element after a specified delay
    function showAfter(delay, el) {
        el.classList.add("hide");
        setTimeout(function() { el.classList.remove("hide") }, delay);
    }

    // Scrolls the page down, but no further than the bottom edge of what you could
    // see previously, so it doesn't go too far.
    function scrollDown(previousBottomEdge) {

        // Line up top of screen with the bottom of where the previous content ended
        var target = previousBottomEdge;

        // Can't go further than the very bottom of the page
        var limit = outerScrollContainer.scrollHeight - outerScrollContainer.clientHeight;
        if( target > limit ) target = limit;

        var start = outerScrollContainer.scrollTop;

        var dist = target - start;
        var duration = 300 + 300*dist/100;
        var startTime = null;
        function step(time) {
            if( startTime == null ) startTime = time;
            var t = (time-startTime) / duration;
            var lerp = 3*t*t - 2*t*t*t; // ease in/out
            outerScrollContainer.scrollTo(0, (1.0-lerp)*start + lerp*target);
            if( t < 1 ) requestAnimationFrame(step);
        }
        requestAnimationFrame(step);
    }

    // The Y coordinate of the bottom end of all the story content, used
    // for growing the container, and deciding how far to scroll.
    function contentBottomEdgeY() {
        var bottomElement = storyContainer.lastElementChild;
        return bottomElement ? bottomElement.offsetTop + bottomElement.offsetHeight : 0;
    }

    // Remove all elements that match the given selector. Used for removing choices after
    // you've picked one, as well as for the CLEAR and RESTART tags.
    function removeAll(selector)
    {
        var allElements = storyContainer.querySelectorAll(selector);
        for(var i=0; i<allElements.length; i++) {
            var el = allElements[i];
            el.parentNode.removeChild(el);
        }
    }

    // Used for hiding and showing the header when you CLEAR or RESTART the story respectively.
    function setVisible(selector, visible)
    {
        var allElements = storyContainer.querySelectorAll(selector);
        for(var i=0; i<allElements.length; i++) {
            var el = allElements[i];
            if( !visible )
                el.classList.add("invisible");
            else
                el.classList.remove("invisible");
        }
    }

    // Helper for parsing out tags of the form:
    //  # PROPERTY: value
    // e.g. IMAGE: source path
    function splitPropertyTag(tag) {
        var propertySplitIdx = tag.indexOf(":");
        if( propertySplitIdx != null ) {
            var property = tag.substr(0, propertySplitIdx).trim();
            var val = tag.substr(propertySplitIdx+1).trim();
            return {
                property: property,
                val: val
            };
        }

        return null;
    }
	
	// Set a minimum and maximum value for the sentence animate speeds, to ensure that very short and very long sentences don't look weird
	function smoothSentenceAnimationLengths(len, speed) {
		
		var duration = len * speed
		
		// Nothing can be shorter than 1 second
		if ( duration < 500 ) {
			return 500
		}
		
		// Or longer than 3
		if ( duration > 1500 ) {
			return 1500
		}
		
		else {
			return duration
		}
		
	}

    // Loads save state if exists in the browser memory
    function loadSavePoint() {

        try {
            let savedState = window.localStorage.getItem('save-state');
			let savedMusic = window.localStorage.getItem('music-state');
                  if('audioLoop' in this) {
                    this.audioLoop.pause();
                    this.audioLoop.removeAttribute('src');
                    this.audioLoop.load();
                  }
				  if(splitTag.val != "stop") {
						this.audioLoop = new Audio(savedMusic);
						this.audioLoop.play();
						this.audioLoop.loop = true;
					}
				
            if (savedState) {
                story.state.LoadJson(savedState);
                return true;
            }
        } catch (e) {
            console.debug("Couldn't load save state");
        }
        return false;
    }
	


    // Detects which theme (light or dark) to use
    function setupTheme(globalTagTheme) {

        // load theme from browser memory
        var savedTheme;
        try {
            savedTheme = window.localStorage.getItem('theme');
        } catch (e) {
            console.debug("Couldn't load saved theme");
        }

        // Check whether the OS/browser is configured for dark mode
        var browserDark = window.matchMedia("(prefers-color-scheme: dark)").matches;

        if (savedTheme === "dark"
            || (savedTheme == undefined && globalTagTheme === "dark")
            || (savedTheme == undefined && globalTagTheme == undefined && browserDark))
            document.body.classList.add("dark");
    }

    // Used to hook up the functionality for global functionality buttons
    function setupButtons(hasSave) {

        let rewindEl = document.getElementById("rewind");
        if (rewindEl) rewindEl.addEventListener("click", function(event) {
            removeAll("p");
            removeAll("img");
            setVisible(".header", false);
            restart();
        });

        let saveEl = document.getElementById("save");
        if (saveEl) saveEl.addEventListener("click", function(event) {
            try {
                window.localStorage.setItem('save-state', savePoint);
				window.localStorage.setItem('music-state', saveAudio);
                document.getElementById("reload").removeAttribute("disabled");
                window.localStorage.setItem('theme', document.body.classList.contains("dark") ? "dark" : "");
            } catch (e) {
                console.warn("Couldn't save state");
            }

        });

        let reloadEl = document.getElementById("reload");
        if (!hasSave) {
            reloadEl.setAttribute("disabled", "disabled");
        }
        reloadEl.addEventListener("click", function(event) {
            if (reloadEl.getAttribute("disabled"))
                return;

            removeAll("p");
            removeAll("img");
            try {
				loadSavePoint();
            } catch (e) {
                console.debug("Couldn't load save state");
            }
            continueStory(true);
        });
		
		

    }
	
	function splitChoiceTags(choice) {
		
		var allTagsThisChoice = []
		
		while ( choice.text.includes("<<") ) {
			
			// Get the three-character tag
			var choiceTag = choice.text.substr(choice.text.indexOf("<<"), choice.text.indexOf(">>")) 
			
			// Clip the current tag out of the choice text that will be printed
			choice.text = choice.text.substr(choice.text.indexOf(">>")+2)
			
			// Trim the <> from the tag
			choiceTag = choiceTag.substr(2,choiceTag.length-1)
			
			// Add the current tag to the list of all tags for this choice
			allTagsThisChoice.push(choiceTag) 
		}
		
		return {
			tags: allTagsThisChoice
		}
		
	}

	function fadeAudioLoop(newAudioSrc) {
				
		fadeAudio = setInterval(function () {
			
			// Only fade it not at zero already
			if (this.audioLoop.volume > 0) {
				this.audioLoop.volume -= 0.1;
			}
			
			// When the volume is at zero, stop the interval
			if ( this.audioLoop.volume < 0.1 ) {
				clearInterval(fadeAudio);
				this.audioLoop.pause();
				
				setNewAudio(newAudioSrc);
				
			}
			
		}, 200);
	}
	
	function setNewAudio(newAudioSrc) {
				
				clearInterval(fadeAudio);
				
				// Reset the audioloop
				this.audioLoop.removeAttribute('src');
				this.audioLoop.load();				 
				
				if (newAudioSrc != null) {
				this.audioLoop = new Audio(newAudioSrc);
				this.audioLoop.volume = 1;
				this.audioLoop.play();
				this.audioLoop.loop = true;
		}
	}
		
	
	
	


})(storyContent);

